/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.msgsvc;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import java.io.BufferedOutputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class FcsEntity
implements RemoteEntity {
    private static final String TRACE_MASKT = "XMSGFE T";
    private static final String TRACE_MASKF = "XMSGFE F";
    private static final String TRACE_MASKD = "XMSGFE D";
    protected static final String CLASS_NAME = "com.ibm.hwmca.fw.util.msgsvc.FcsEntity";
    private MachineId machid = null;

    public FcsEntity(MachineId machid) {
        this.machid = machid;
        Trace.trace(TRACE_MASKD, "<-> ctor: FCS id = " + this.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(Message msg) throws HException {
        block10: {
            Trace.trace(TRACE_MASKD, "--> publish (FCS id=" + this.toString() + ", msgid=" + msg.getMessageId().getId() + ")");
            Socket s = null;
            try {
                try {
                    FcsServiceId svcid = new FcsServiceId("com.ibm.hwmca.fw.util.msgsvc.FcsSupporter-" + msg.getMessageId().getId(), 1.0);
                    InetAddress[] addrs = this.machid.getNicAddresses();
                    int[] order = new int[addrs.length];
                    int firstIdx = 0;
                    int lastIdx = order.length - 1;
                    for (int idx = 0; idx < order.length; ++idx) {
                        if (addrs[idx].isSiteLocalAddress()) {
                            order[lastIdx--] = idx;
                            continue;
                        }
                        order[firstIdx++] = idx;
                    }
                    s = FcsConnection.connect(this.machid, svcid, order).getSocket();
                    ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(s.getOutputStream()));
                    out.flush();
                    out.writeObject(msg);
                    out.flush();
                    s.close();
                }
                catch (HException he) {
                    Trace.trace(TRACE_MASKT, "Error publishing");
                    throw he;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "Error publishing");
                    Trace.trace(TRACE_MASKT, e);
                    throw new HException("Error publishing:" + e.getMessage());
                }
                Object var10_12 = null;
                if (s == null || s.isClosed()) break block10;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (s == null) throw throwable;
                if (s.isClosed()) throw throwable;
                try {
                    s.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            s.close();
        }
        Trace.trace(TRACE_MASKD, "<-- publish");
    }

    public String getMTMS() {
        String mt = this.machid.getMachineType();
        String mm = this.machid.getMachineModel();
        String ms = this.machid.getMachineSerial();
        if (mt == null) {
            mt = "0";
        }
        if (mm == null) {
            mm = "0";
        }
        if (ms == null) {
            ms = "0";
        }
        return mt + "-" + mm + "/" + ms;
    }

    public String toString() {
        return this.machid.getNicAddresses()[0].toString();
    }

    public InetAddress[] getNicAddresses() {
        return this.machid.getNicAddresses();
    }
}

